/*!
 * # Semantic UI 2.2.6 - Progress
 * http://github.com/semantic-org/semantic-ui/
 *
 *
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(e,t,n,r){"use strict";t="undefined"!=typeof t&&t.Math==Math?t:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")();"undefined"!=typeof t&&t.Math==Math?t:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")();e.fn.progress=function(t){var a,o=e(this),i=o.selector||"",s=(new Date).getTime(),l=[],c=arguments[0],u="string"==typeof c,d=[].slice.call(arguments,1);return o.each(function(){var o,g,p=e.isPlainObject(t)?e.extend(!0,{},e.fn.progress.settings,t):e.extend({},e.fn.progress.settings),v=p.className,f=p.metadata,m=p.namespace,b=p.selector,h=p.error,x="."+m,y="module-"+m,w=e(this),V=e(this).find(b.bar),C=e(this).find(b.progress),E=e(this).find(b.label),P=this,T=w.data(y),M=!1;g={initialize:function(){g.debug("Initializing progress bar",p),g.set.duration(),g.set.transitionEvent(),g.read.metadata(),g.read.settings(),g.instantiate()},instantiate:function(){g.verbose("Storing instance of progress",g),T=g,w.data(y,g)},destroy:function(){g.verbose("Destroying previous progress for",w),clearInterval(T.interval),g.remove.state(),w.removeData(y),T=r},reset:function(){g.remove.nextValue(),g.update.progress(0)},complete:function(){(g.percent===r||g.percent<100)&&(g.remove.progressPoll(),g.set.percent(100))},read:{metadata:function(){var e={percent:w.data(f.percent),total:w.data(f.total),value:w.data(f.value)};e.percent&&(g.debug("Current percent value set from metadata",e.percent),g.set.percent(e.percent)),e.total&&(g.debug("Total value set from metadata",e.total),g.set.total(e.total)),e.value&&(g.debug("Current value set from metadata",e.value),g.set.value(e.value),g.set.progress(e.value))},settings:function(){p.total!==!1&&(g.debug("Current total set in settings",p.total),g.set.total(p.total)),p.value!==!1&&(g.debug("Current value set in settings",p.value),g.set.value(p.value),g.set.progress(g.value)),p.percent!==!1&&(g.debug("Current percent set in settings",p.percent),g.set.percent(p.percent))}},bind:{transitionEnd:function(e){var t=g.get.transitionEnd();V.one(t+x,function(t){clearTimeout(g.failSafeTimer),e.call(this,t)}),g.failSafeTimer=setTimeout(function(){V.triggerHandler(t)},p.duration+p.failSafeDelay),g.verbose("Adding fail safe timer",g.timer)}},increment:function(e){var t,n,r;g.has.total()?(n=g.get.value(),e=e||1,r=n+e):(n=g.get.percent(),e=e||g.get.randomValue(),r=n+e,t=100,g.debug("Incrementing percentage by",n,r)),r=g.get.normalizedValue(r),g.set.progress(r)},decrement:function(e){var t,n,r=g.get.total();r?(t=g.get.value(),e=e||1,n=t-e,g.debug("Decrementing value by",e,t)):(t=g.get.percent(),e=e||g.get.randomValue(),n=t-e,g.debug("Decrementing percentage by",e,t)),n=g.get.normalizedValue(n),g.set.progress(n)},has:{progressPoll:function(){return g.progressPoll},total:function(){return g.get.total()!==!1}},get:{text:function(e){var t=g.value||0,n=g.total||0,r=M?g.get.displayPercent():g.percent||0,a=g.total>0?n-t:100-r;return e=e||"",e=e.replace("{value}",t).replace("{total}",n).replace("{left}",a).replace("{percent}",r),g.verbose("Adding variables to progress bar text",e),e},normalizedValue:function(e){if(e<0)return g.debug("Value cannot decrement below 0"),0;if(g.has.total()){if(e>g.total)return g.debug("Value cannot increment above total",g.total),g.total}else if(e>100)return g.debug("Value cannot increment above 100 percent"),100;return e},updateInterval:function(){return"auto"==p.updateInterval?p.duration:p.updateInterval},randomValue:function(){return g.debug("Generating random increment percentage"),Math.floor(Math.random()*p.random.max+p.random.min)},numericValue:function(e){return"string"==typeof e?""!==e.replace(/[^\d.]/g,"")&&+e.replace(/[^\d.]/g,""):e},transitionEnd:function(){var e,t=n.createElement("element"),a={transition:"transitionend",OTransition:"oTransitionEnd",MozTransition:"transitionend",WebkitTransition:"webkitTransitionEnd"};for(e in a)if(t.style[e]!==r)return a[e]},displayPercent:function(){var e=V.width(),t=w.width(),n=parseInt(V.css("min-width"),10),r=e>n?e/t*100:g.percent;return p.precision>0?Math.round(r*(10*p.precision))/(10*p.precision):Math.round(r)},percent:function(){return g.percent||0},value:function(){return g.nextValue||g.value||0},total:function(){return g.total||!1}},create:{progressPoll:function(){g.progressPoll=setTimeout(function(){g.update.toNextValue(),g.remove.progressPoll()},g.get.updateInterval())}},is:{complete:function(){return g.is.success()||g.is.warning()||g.is.error()},success:function(){return w.hasClass(v.success)},warning:function(){return w.hasClass(v.warning)},error:function(){return w.hasClass(v.error)},active:function(){return w.hasClass(v.active)},visible:function(){return w.is(":visible")}},remove:{progressPoll:function(){g.verbose("Removing progress poll timer"),g.progressPoll&&(clearTimeout(g.progressPoll),delete g.progressPoll)},nextValue:function(){g.verbose("Removing progress value stored for next update"),delete g.nextValue},state:function(){g.verbose("Removing stored state"),delete g.total,delete g.percent,delete g.value},active:function(){g.verbose("Removing active state"),w.removeClass(v.active)},success:function(){g.verbose("Removing success state"),w.removeClass(v.success)},warning:function(){g.verbose("Removing warning state"),w.removeClass(v.warning)},error:function(){g.verbose("Removing error state"),w.removeClass(v.error)}},set:{barWidth:function(e){e>100?g.error(h.tooHigh,e):e<0?g.error(h.tooLow,e):(V.css("width",e+"%"),w.attr("data-percent",parseInt(e,10)))},duration:function(e){e=e||p.duration,e="number"==typeof e?e+"ms":e,g.verbose("Setting progress bar transition duration",e),V.css({"transition-duration":e})},percent:function(e){e="string"==typeof e?+e.replace("%",""):e,e=p.precision>0?Math.round(e*(10*p.precision))/(10*p.precision):Math.round(e),g.percent=e,g.has.total()||(g.value=p.precision>0?Math.round(e/100*g.total*(10*p.precision))/(10*p.precision):Math.round(e/100*g.total*10)/10,p.limitValues&&(g.value=g.value>100?100:g.value<0?0:g.value)),g.set.barWidth(e),g.set.labelInterval(),g.set.labels(),p.onChange.call(P,e,g.value,g.total)},labelInterval:function(){var t=function(){g.verbose("Bar finished animating, removing continuous label updates"),clearInterval(g.interval),M=!1,g.set.labels()};clearInterval(g.interval),g.bind.transitionEnd(t),M=!0,g.interval=setInterval(function(){var t=e.contains(n.documentElement,P);t||(clearInterval(g.interval),M=!1),g.set.labels()},p.framerate)},labels:function(){g.verbose("Setting both bar progress and outer label text"),g.set.barLabel(),g.set.state()},label:function(e){e=e||"",e&&(e=g.get.text(e),g.verbose("Setting label to text",e),E.text(e))},state:function(e){e=e!==r?e:g.percent,100===e?p.autoSuccess&&!(g.is.warning()||g.is.error()||g.is.success())?(g.set.success(),g.debug("Automatically triggering success at 100%")):(g.verbose("Reached 100% removing active state"),g.remove.active(),g.remove.progressPoll()):e>0?(g.verbose("Adjusting active progress bar label",e),g.set.active()):(g.remove.active(),g.set.label(p.text.active))},barLabel:function(e){e!==r?C.text(g.get.text(e)):"ratio"==p.label&&g.total?(g.verbose("Adding ratio to bar label"),C.text(g.get.text(p.text.ratio))):"percent"==p.label&&(g.verbose("Adding percentage to bar label"),C.text(g.get.text(p.text.percent)))},active:function(e){e=e||p.text.active,g.debug("Setting active state"),p.showActivity&&!g.is.active()&&w.addClass(v.active),g.remove.warning(),g.remove.error(),g.remove.success(),e=p.onLabelUpdate("active",e,g.value,g.total),e&&g.set.label(e),g.bind.transitionEnd(function(){p.onActive.call(P,g.value,g.total)})},success:function(e){e=e||p.text.success||p.text.active,g.debug("Setting success state"),w.addClass(v.success),g.remove.active(),g.remove.warning(),g.remove.error(),g.complete(),p.text.success?(e=p.onLabelUpdate("success",e,g.value,g.total),g.set.label(e)):(e=p.onLabelUpdate("active",e,g.value,g.total),g.set.label(e)),g.bind.transitionEnd(function(){p.onSuccess.call(P,g.total)})},warning:function(e){e=e||p.text.warning,g.debug("Setting warning state"),w.addClass(v.warning),g.remove.active(),g.remove.success(),g.remove.error(),g.complete(),e=p.onLabelUpdate("warning",e,g.value,g.total),e&&g.set.label(e),g.bind.transitionEnd(function(){p.onWarning.call(P,g.value,g.total)})},error:function(e){e=e||p.text.error,g.debug("Setting error state"),w.addClass(v.error),g.remove.active(),g.remove.success(),g.remove.warning(),g.complete(),e=p.onLabelUpdate("error",e,g.value,g.total),e&&g.set.label(e),g.bind.transitionEnd(function(){p.onError.call(P,g.value,g.total)})},transitionEvent:function(){o=g.get.transitionEnd()},total:function(e){g.total=e},value:function(e){g.value=e},progress:function(e){g.has.progressPoll()?(g.debug("Updated within interval, setting next update to use new value",e),g.set.nextValue(e)):(g.debug("First update in progress update interval, immediately updating",e),g.update.progress(e),g.create.progressPoll())},nextValue:function(e){g.nextValue=e}},update:{toNextValue:function(){var e=g.nextValue;e&&(g.debug("Update interval complete using last updated value",e),g.update.progress(e),g.remove.nextValue())},progress:function(e){var t;e=g.get.numericValue(e),e===!1&&g.error(h.nonNumeric,e),e=g.get.normalizedValue(e),g.has.total()?(g.set.value(e),t=e/g.total*100,g.debug("Calculating percent complete from total",t),g.set.percent(t)):(t=e,g.debug("Setting value to exact percentage value",t),g.set.percent(t))}},setting:function(t,n){if(g.debug("Changing setting",t,n),e.isPlainObject(t))e.extend(!0,p,t);else{if(n===r)return p[t];e.isPlainObject(p[t])?e.extend(!0,p[t],n):p[t]=n}},internal:function(t,n){if(e.isPlainObject(t))e.extend(!0,g,t);else{if(n===r)return g[t];g[t]=n}},debug:function(){!p.silent&&p.debug&&(p.performance?g.performance.log(arguments):(g.debug=Function.prototype.bind.call(console.info,console,p.name+":"),g.debug.apply(console,arguments)))},verbose:function(){!p.silent&&p.verbose&&p.debug&&(p.performance?g.performance.log(arguments):(g.verbose=Function.prototype.bind.call(console.info,console,p.name+":"),g.verbose.apply(console,arguments)))},error:function(){p.silent||(g.error=Function.prototype.bind.call(console.error,console,p.name+":"),g.error.apply(console,arguments))},performance:{log:function(e){var t,n,r;p.performance&&(t=(new Date).getTime(),r=s||t,n=t-r,s=t,l.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:P,"Execution Time":n})),clearTimeout(g.performance.timer),g.performance.timer=setTimeout(g.performance.display,500)},display:function(){var t=p.name+":",n=0;s=!1,clearTimeout(g.performance.timer),e.each(l,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",i&&(t+=" '"+i+"'"),(console.group!==r||console.table!==r)&&l.length>0&&(console.groupCollapsed(t),console.table?console.table(l):e.each(l,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),l=[]}},invoke:function(t,n,o){var i,s,l,c=T;return n=n||d,o=P||o,"string"==typeof t&&c!==r&&(t=t.split(/[\. ]/),i=t.length-1,e.each(t,function(n,a){var o=n!=i?a+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(c[o])&&n!=i)c=c[o];else{if(c[o]!==r)return s=c[o],!1;if(!e.isPlainObject(c[a])||n==i)return c[a]!==r?(s=c[a],!1):(g.error(h.method,t),!1);c=c[a]}})),e.isFunction(s)?l=s.apply(o,n):s!==r&&(l=s),e.isArray(a)?a.push(l):a!==r?a=[a,l]:l!==r&&(a=l),s}},u?(T===r&&g.initialize(),g.invoke(c)):(T!==r&&T.invoke("destroy"),g.initialize())}),a!==r?a:this},e.fn.progress.settings={name:"Progress",namespace:"progress",silent:!1,debug:!1,verbose:!1,performance:!0,random:{min:2,max:5},duration:300,updateInterval:"auto",autoSuccess:!0,showActivity:!0,limitValues:!0,label:"percent",precision:0,framerate:1e3/30,percent:!1,total:!1,value:!1,failSafeDelay:100,onLabelUpdate:function(e,t,n,r){return t},onChange:function(e,t,n){},onSuccess:function(e){},onActive:function(e,t){},onError:function(e,t){},onWarning:function(e,t){},error:{method:"The method you called is not defined.",nonNumeric:"Progress value is non numeric",tooHigh:"Value specified is above 100%",tooLow:"Value specified is below 0%"},regExp:{variable:/\{\$*[A-z0-9]+\}/g},metadata:{percent:"percent",total:"total",value:"value"},selector:{bar:"> .bar",label:"> .label",progress:".bar > .progress"},text:{active:!1,error:!1,success:!1,warning:!1,percent:"{percent}%",ratio:"{value} of {total}"},className:{active:"active",error:"error",success:"success",warning:"warning"}}}(jQuery,window,document);