<?php


/**
 *     \file       htdocs/societe/societecontact.php
 *     \ingroup    societe
 *     \brief      Onglet de gestion des contacts additionnel d'une société
 */

require '../main.inc.php';
require_once DOL_DOCUMENT_ROOT.'/contact/class/contact.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/company.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formcompany.class.php';

$langs->load("orders");
$langs->load("companies");

$id=GETPOST('id','int')?GETPOST('id','int'):GETPOST('socid','int');
$ref=GETPOST('ref','alpha');
$action=GETPOST('action','alpha');

// Security check
if ($user->societe_id) $socid=$user->societe_id;
$result = restrictedArea($user, 'societe', $id,'');

$object = new Societe($db);


/*
 * Actions
 */

if ($action == 'addcontact' && $user->rights->societe->creer)
{
	$result = $object->fetch($id);

    if ($result > 0 && $id > 0)
    {
    	$contactid = (GETPOST('userid','int') ? GETPOST('userid','int') : GETPOST('contactid','int'));
  		$result = $object->add_contact($contactid, $_POST["type"], $_POST["source"]);
    }

	if ($result >= 0)
	{
		header("Location: ".$_SERVER['PHP_SELF']."?id=".$object->id);
		exit;
	}
	else
	{
		if ($object->error == 'DB_ERROR_RECORD_ALREADY_EXISTS')
		{
			$langs->load("errors");
			$mesg = '<div class="error">'.$langs->trans("ErrorThisContactIsAlreadyDefinedAsThisType").'</div>';
		}
		else
		{
			$mesg = '<div class="error">'.$object->error.'</div>';
		}
	}
}

// bascule du statut d'un contact
else if ($action == 'swapstatut' && $user->rights->societe->creer)
{
	if ($object->fetch($id))
	{
	    $result=$object->swapContactStatus(GETPOST('ligne'));
	}
	else
	{
		dol_print_error($db);
	}
}

// Efface un contact
else if ($action == 'deletecontact' && $user->rights->societe->creer)
{
	$object->fetch($id);
	$result = $object->delete_contact($_GET["lineid"]);

	if ($result >= 0)
	{
		header("Location: ".$_SERVER['PHP_SELF']."?id=".$object->id);
		exit;
	}
	else {
		dol_print_error($db);
	}
}

else if ($action == 'setaddress' && $user->rights->societe->creer)
{
	$object->fetch($id);
	$result=$object->setDeliveryAddress($_POST['fk_address']);
	if ($result < 0) dol_print_error($db,$object->error);
}

/*
 * View
 */

$help_url='EN:Module_Third_Parties|FR:Module_Tiers|ES:Empresas';
llxHeader('',$langs->trans("ThirdParty"),$help_url);


$form = new Form($db);
$formcompany = new FormCompany($db);
$formother = new FormOther($db);
$contactstatic=new Contact($db);
$userstatic=new User($db);


/* *************************************************************************** */
/*                                                                             */
/* Mode vue et edition                                                         */
/*                                                                             */
/* *************************************************************************** */

if ($id > 0 || ! empty($ref))
{
	if ($object->fetch($id, $ref) > 0)
	{
		$soc = new Societe($db);
		$soc->fetch($object->socid);

		$head = societe_prepare_head($object);
		dol_fiche_head($head, 'contact', $langs->trans("ThirdParty"),0,'company');

		print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">';
		print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';
		print '<table class="border" width="100%">';
		print '<tr><td width="20%">'.$langs->trans('ThirdPartyName').'</td>';
		print '<td colspan="3">';
		print $form->showrefnav($object,'id','',($user->societe_id?0:1),'rowid','nom');
		print '</td></tr>';

		// Alias names (commercial, trademark or alias names)
		print '<tr><td valign="top">'.$langs->trans('AliasNames').'</td><td colspan="3">';
		print $object->name_alias;
		print "</td></tr>";

		if (! empty($conf->global->SOCIETE_USEPREFIX))  // Old not used prefix field
		{
		    print '<tr><td>'.$langs->trans('Prefix').'</td><td colspan="3">'.$object->prefix_comm.'</td></tr>';
		}

		if ($object->client)
		{
		    print '<tr><td>';
		    print $langs->trans('CustomerCode').'</td><td colspan="3">';
		    print $object->code_client;
		    if ($object->check_codeclient() <> 0) print ' <font class="error">('.$langs->trans("WrongCustomerCode").')</font>';
		    print '</td></tr>';
		}

		if ($object->fournisseur)
		{
		    print '<tr><td>';
		    print $langs->trans('SupplierCode').'</td><td colspan="3">';
		    print $object->code_fournisseur;
		    if ($object->check_codefournisseur() <> 0) print ' <font class="error">('.$langs->trans("WrongSupplierCode").')</font>';
		    print '</td></tr>';
		}
		print '</table></form>';
		print '<br>';

		// Contacts lines (modules that overwrite templates must declare this into descriptor)
		$dirtpls=array_merge($conf->modules_parts['tpl'],array('/core/tpl'));
		foreach($dirtpls as $reldir)
		{
			$res=@include dol_buildpath($reldir.'/contacts.tpl.php');
			if ($res) break;
		}

		// additionnal list with adherents of company
		if (! empty($conf->adherent->enabled) && $user->rights->adherent->lire)
		{
			require_once DOL_DOCUMENT_ROOT.'/adherents/class/adherent.class.php';
			require_once DOL_DOCUMENT_ROOT.'/adherents/class/adherent_type.class.php';

			$membertypestatic=new AdherentType($db);
			$memberstatic=new Adherent($db);

			$langs->load("members");
			$sql = "SELECT d.rowid, d.login, d.lastname, d.firstname, d.societe as company, d.fk_soc,";
			$sql.= " d.datefin,";
			$sql.= " d.email, d.fk_adherent_type as type_id, d.morphy, d.statut,";
			$sql.= " t.libelle as type, t.cotisation";
			$sql.= " FROM ".MAIN_DB_PREFIX."adherent as d";
			$sql.= ", ".MAIN_DB_PREFIX."adherent_type as t";
			$sql.= " WHERE d.fk_soc=".$id;

			dol_syslog("get list sql=".$sql);
			$resql = $db->query($sql);
			if ($resql)
			{
				$num = $db->num_rows($resql);

				if ($num  > 0 )
				{
					$titre=$langs->trans("MembersListOfTiers");
					print '<br>';

					print_barre_liste($titre,$page,$_SERVER["PHP_SELF"],$param,$sortfield,$sortorder,'',$num,$nbtotalofrecords,'');

					print "<table class=\"noborder\" width=\"100%\">";
					print '<tr class="liste_titre">';
					print_liste_field_titre($langs->trans("Ref"),$_SERVER["PHP_SELF"],"d.rowid",$param,"","",$sortfield,$sortorder);
					print_liste_field_titre($langs->trans("Name")." / ".$langs->trans("Company"),$_SERVER["PHP_SELF"],"d.lastname",$param,"","",$sortfield,$sortorder);
					print_liste_field_titre($langs->trans("Login"),$_SERVER["PHP_SELF"],"d.login",$param,"","",$sortfield,$sortorder);
					print_liste_field_titre($langs->trans("Type"),$_SERVER["PHP_SELF"],"t.libelle",$param,"","",$sortfield,$sortorder);
					print_liste_field_titre($langs->trans("Person"),$_SERVER["PHP_SELF"],"d.morphy",$param,"","",$sortfield,$sortorder);
					print_liste_field_titre($langs->trans("EMail"),$_SERVER["PHP_SELF"],"d.email",$param,"","",$sortfield,$sortorder);
					print_liste_field_titre($langs->trans("Status"),$_SERVER["PHP_SELF"],"d.statut,d.datefin",$param,"","",$sortfield,$sortorder);
					print_liste_field_titre($langs->trans("EndSubscription"),$_SERVER["PHP_SELF"],"d.datefin",$param,"",'align="center"',$sortfield,$sortorder);
					print "</tr>\n";

					$var=True;
					$i=0;
					while ($i < $num && $i < $conf->liste_limit)
					{
						$objp = $db->fetch_object($resql);

						$datefin=$db->jdate($objp->datefin);
						$memberstatic->id=$objp->rowid;
						$memberstatic->ref=$objp->rowid;
						$memberstatic->lastname=$objp->lastname;
						$memberstatic->firstname=$objp->firstname;

						$companyname=$objp->company;

						$var=!$var;
						print "<tr ".$bc[$var].">";

						// Ref
						print "<td>";
						print $memberstatic->getNomUrl(1);
						print "</td>\n";

						// Lastname
						print "<td><a href=\"card.php?rowid=$objp->rowid\">";
						print ((! empty($objp->lastname) || ! empty($objp->firstname)) ? dol_trunc($memberstatic->getFullName($langs)) : '');
						print (((! empty($objp->lastname) || ! empty($objp->firstname)) && ! empty($companyname)) ? ' / ' : '');
						print (! empty($companyname) ? dol_trunc($companyname, 32) : '');
						print "</a></td>\n";

						// Login
						print "<td>".$objp->login."</td>\n";

						// Type
						$membertypestatic->id=$objp->type_id;
						$membertypestatic->libelle=$objp->type;
						print '<td class="nowrap">';
						print $membertypestatic->getNomUrl(1,32);
						print '</td>';

						// Moral/Physique
						print "<td>".$memberstatic->getmorphylib($objp->morphy)."</td>\n";

						// EMail
						print "<td>".dol_print_email($objp->email,0,0,1)."</td>\n";

						// Statut
						print '<td class="nowrap">';
						print $memberstatic->LibStatut($objp->statut,$objp->cotisation,$datefin,2);
						print "</td>";

						// End of subscription date
						if ($datefin)
						{
							print '<td align="center" class="nowrap">';
							print dol_print_date($datefin,'day');
							if ($datefin < ($now -  $conf->adherent->cotisation->warning_delay) && $objp->statut > 0) print " ".img_warning($langs->trans("SubscriptionLate"));
							print '</td>';
						}
						else
						{
							print '<td align="left" class="nowrap">';
							if ($objp->cotisation == 'yes')
							{
								print $langs->trans("SubscriptionNotReceived");
								if ($objp->statut > 0) print " ".img_warning();
							}
							else
							{
								print '&nbsp;';
							}
							print '</td>';
						}

						print "</tr>\n";
						$i++;
					}
					print "</table>\n";
				}
			}
		}
	}
	else
	{
		// Contrat non trouve
		print "ErrorRecordNotFound";
	}
}

$db->close();
llxFooter();
